package MediumTypes
  record BaseMedium "Base record for medium definitions"

    // fixedMixingRatio is set via modifier using inheritance
    // from this BaseMedium record
    constant Boolean fixedMixingRatio;

    // nc_propertyCalculation is set via modifier using inheritance
    // from this BaseMedium record
    constant Integer nc_propertyCalculation(min=1);

    constant Real[nc_propertyCalculation] mixingRatio_propertyCalculation;

    // Dependent on evaluation of above-defined fixedMixingRatio
    final constant Integer nc=if fixedMixingRatio then 1 else
        nc_propertyCalculation;

    constant Real[nc] defaultMixingRatio=if fixedMixingRatio then {1} else
        mixingRatio_propertyCalculation;
  end BaseMedium;


  record TILMedia_Water
    extends BaseMedium(
      final fixedMixingRatio=true,
      final nc_propertyCalculation=1,
      final mixingRatio_propertyCalculation={1});

  end TILMedia_Water;

  function pressure_dTxi
    input MediumTypes.BaseMedium medium annotation (choicesAllMatching=true);
    input Real[:] xi=zeros(medium.nc - 1);
    output Real p;

  algorithm
    p := 101325;

  end pressure_dTxi;

  model MediumObject
    replaceable parameter MediumTypes.BaseMedium medium constrainedby
      MediumTypes.BaseMedium;

    Real d;

  equation
    d = 1013;

  end MediumObject;




end MediumTypes;
